/*
	$Id: pc105_tr_f.c,v 1.1 2011/12/23 13:03:18 krashan Exp $
	
	Desc: Turkish PC105 Keymap
	Lang: English
*/

#include <devices/keymap.h>

#define VERSION     51
#define REVISION    4
#define KMDESC      "Turkish F keyboard with 105 keys"
#define KMID        "pc105_tr_f 51.4"
#define KMNAME      "pc105_tr_f"
#define KMLANG      "Trke"
#define KMLANGINT   "Turkish"
#define KMCODEPAGE  "ISO-8859-9"

#define CONST const

extern CONST char  keymapname[];

extern CONST UBYTE lokeymaptypes[];
extern CONST IPTR  lokeymap[];
extern CONST UBYTE locapsable[];
extern CONST UBYTE lorepeatable[];

extern CONST UBYTE hikeymaptypes[];
extern CONST IPTR  hikeymap[];
extern CONST UBYTE hicapsable[];
extern CONST UBYTE hirepeatable[];

static const struct Resident ROMTag;

struct ExtendedKeyMapNode km =
{
	{
	NULL, NULL, NT_EXTENDED, 'E', (char*) keymapname
	},
	{
	(UBYTE *)lokeymaptypes,
	(IPTR  *)lokeymap,
	(UBYTE *)locapsable,
	(UBYTE *)lorepeatable,
	(UBYTE *)hikeymaptypes,
	(IPTR  *)hikeymap,
	(UBYTE *)hicapsable,
	(UBYTE *)hirepeatable
	},
	0,
	(struct Resident *)&ROMTag,
	0
};

CONST char keymapname[] = KMNAME;

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#define N   KC_NOQUAL
#define S   KCF_SHIFT
#define A   KCF_ALT
#define C   KCF_CONTROL
#define D   KCF_DEAD
#define V   KC_VANILLA
#define ST  KCF_STRING
#define NOP KCF_NOP


STATIC CONST UBYTE lokeymaptypes[] =
{
	S|A,    /* 00, RAWKEY_TILDE */
	S|A,    /* 01, RAWKEY_1 */
	S|A,    /* 02, RAWKEY_2 */
	S|A,    /* 03, RAWKEY_3 */
	S|A,    /* 04, RAWKEY_4 */
	S|A,    /* 05, RAWKEY_5 */
	S|A,    /* 06, RAWKEY_6 */
	S|A,    /* 07, RAWKEY_7 */
	S|A,    /* 08, RAWKEY_8 */
	S|A,    /* 09, RAWKEY_9 */
	S|A,    /* 0A, RAWKEY_0 */
	S|A,    /* 0B, RAWKEY_MINUS, */
	S|A,    /* 0C, RAWKEY_EQUAL, */
	S,      /* 0D, RAWKEY_BACKSLASH */
	N,      /* 0E, - */
	S|A,    /* 0F, RAWKEY_KP0 */
	S|A,    /* 10, RAWKEY_Q */
	V,      /* 11, RAWKEY_W */
	V,    /* 12, RAWKEY_E */
	V,      /* 13, RAWKEY_R */
	V,      /* 14, RAWKEY_T */
	V,      /* 15, RAWKEY_Y */
	V,      /* 16, RAWKEY_U */
	V,      /* 17, RAWKEY_I */
	V,      /* 18, RAWKEY_O */
	V,      /* 19, RAWKEY_P */
	S|A,    /* 1A, RAWKEY_LBRACKET */
	S|A,    /* 1B, RAWKEY_RBRACKET */
	S|A,    /* 1C, - */
	S|A,    /* 1D, RAWKEY_KP_1 */
	S|A,    /* 1E, RAWKEY_KP_2 */
	S|A,    /* 1F, RAWKEY_KP_3 */
	S|A,    /* 20, RAWKEY_A */
	S|A,    /* 21, RAWKEY_S */
	S|A,      /* 22, RAWKEY_D */
	V,      /* 23, RAWKEY_F */
	V,      /* 24, RAWKEY_G */
	V,      /* 25, RAWKEY_H */
	V,      /* 26, RAWKEY_J */
	V,      /* 27, RAWKEY_K */
	V,      /* 28, RAWKEY_L */
	V,    /* 29, RAWKEY_SEMICOLON */
	S|A,      /* 2A, RAWKEY_QUOTE */
	S|A,    /* 2B, RAWKEY_2B */
	NOP,    /* 2C, - */
	N,      /* 2D, RAWKEY_KP_4 */
	N,      /* 2E, RAWKEY_KP_5 */
	N,      /* 2F, RAWKEY_KP_6 */
	S|A,    /* 30, RAWKEY_LESSGREATER */
	S|A,      /* 31, RAWKEY_Z */
	S|A,      /* 32, RAWKEY_X */
	S|A,    /* 33, RAWKEY_C */
	S|A,      /* 34, RAWKEY_V */
	V,      /* 35, RAWKEY_B */
	V,      /* 36, RAWKEY_N */
	V,      /* 37, RAWKEY_M */
	S|A,    /* 38, RAWKEY_COMMA */
	S|A,    /* 39, RAWKEY_PERIOD */
	S|A,      /* 3A, RAWKEY_SLASH */
	N,      /* 3B, - */
	N,      /* 3C, RAWKEY_KP_DECIMAL */
	N,      /* 3D, RAWKEY_KP_7 */
	N,      /* 3E, RAWKEY_KP_8 */
	N,      /* 3F, RAWKEY_KP_9 */
};

STATIC CONST UBYTE hikeymaptypes[] =
{
	N,      /* 40, RAWKEY_SPACE */
	N,      /* 41, RAWKEY_BACKSPACE */
	ST|S,   /* 42, RAWKEY_TAB */
	N,      /* 43, RAWKEY_KP_ENTER */
	N,      /* 44, RAWKEY_RETURN */
	N,      /* 45, RAWKEY_ESCAPE */
	N,      /* 46, RAWKEY_DEL  */
	ST|S,   /* 47, RAWKEY_INSERT */
	ST|S,   /* 48, RAWKEY_PAGEUP */
	ST|S,   /* 49, RAWKEY_PAGEDOWN */
	N,      /* 4A, RAWKEY_KP_MINUS */
	ST|S,   /* 4B, RAWKEY_F11 */
	ST|S,   /* 4C, RAWKEY_CURSORUP */
	ST|S,   /* 4D, RAWKEY_CURSORDOWN */
	ST|S,   /* 4E, RAWKEY_CURSORRIGHT */
	ST|S,   /* 4F, RAWKEY_CURSORLEFT */
	ST|S,   /* 50, RAWKEY_F1 */
	ST|S,   /* 51, RAWKEY_F2 */
	ST|S,   /* 52, RAWKEY_F3 */
	ST|S,   /* 53, RAWKEY_F4 */
	ST|S,   /* 54, RAWKEY_F5 */
	ST|S,   /* 55, RAWKEY_F6 */
	ST|S,   /* 56, RAWKEY_F7 */
	ST|S,   /* 57, RAWKEY_F8 */
	ST|S,   /* 58, RAWKEY_F9 */
	ST|S,   /* 59, RAWKEY_F10 */
	NOP,    /* 5A, - */
	N,      /* 5B, - */
	N,      /* 5C, RAWKEY_KP_DIVIDE */
	N,      /* 5D, RAWKEY_KP_MULTIPLE */
	N,      /* 5E, RAWKEY_KP_PLUS */
	ST,     /* 5F, RAWKEY_HELP */
	NOP,    /* 60, RAWKEY_LSHIFT */
	NOP,    /* 61, RAWKEY_RSHIFT */
	NOP,    /* 62, RAWKEY_CAPSLOCK */
	NOP,    /* 63, RAWKEY_CONTROL */
	NOP,    /* 64, RAWKEY_LALT */
	NOP,    /* 65, RAWKEY_RALT */
	NOP,    /* 66, RAWKEY_LAMIGA */
	NOP,    /* 67, RAWKEY_RAMIGA */
	NOP,    /* 68, LEFT MOUSE BUTTON*/
	NOP,    /* 69, RIGHT MOUSE BUTTON */
	NOP,    /* 6A, MIDDLE MOUSE BUTTON */
	NOP,    /* 6B, RAWKEY_SCRLOCK */
	NOP,    /* 6C, RAWKEY_PRTSCREEN */
	NOP,    /* 6D, RAWKEY_NUMLOCK */
	ST|A,   /* 6E, RAWKEY_PAUSE */
	ST|S,   /* 6F, RAWKEY_F12 */
	ST|C,   /* 70, RAWKEY_HOME */
	ST|C,   /* 71, RAWKEY_END */
	NOP,    /* 72, RAWKEY_MEDIA1 */
	NOP,    /* 73, RAWKEY_MEDIA2 */
	NOP,    /* 74, RAWKEY_MEDIA3 */
	NOP,    /* 75, RAWKEY_MEDIA4 */
	NOP,    /* 76, RAWKEY_MEDIA5 */
	NOP,    /* 77, RAWKEY_MEDIA6 */
	NOP,    /* 78, - */
	NOP,    /* 79, - */
	NOP,    /* 7A, RAWKEY_NM_WHEEL_UP */
	NOP,    /* 7B, RAWKEY_NM_WHEEL_DOWN */
	NOP,    /* 7C, RAWKEY_NM_WHEEL_LEFT */
	NOP,    /* 7D, RAWKEY_NM_WHEEL_RIGHT */
	NOP,    /* 7E, RAWKEY_NM_BUTTON_FOURTH */
	NOP     /* 7F, - */
};

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#undef STRING
#undef DEAD
#undef BYTES

#define STRING(x) (IPTR)x
#define DEAD(x)   (IPTR)x
#define BYTES(b0, b1, b2, b3) \
	(((UBYTE)b0)<<24) | (((UBYTE)b1)<<16) | (((UBYTE)b2)<<8) | (((UBYTE)b3)<<0)

STATIC CONST IPTR lokeymap[] =
{
	/*---- 1st QWERTY row - 0x00 to 0x0F */

	BYTES(0xAC, 0xAC,  '*',  '+'),  /* 0xAC = NOT SIGN  */
	BYTES(0xB9, 0xB9,  '!',  '1'),  /* 0XB9 = SUPERSCRIPT ONE */
	BYTES(0xB2, 0xB2, 0x22,  '2'),  /* 0xB2 = SUPERSCRIPT TWO, 0x22 = QUOTATION MARK */
	BYTES( '#',  '#',  '^',  '3'),
	BYTES(0xBC, 0xBC,  '$',  '4'),  /* 0xBC = VULGAR FRACTION ONE QUARTER */
	BYTES(0xBD, 0xBD,  '%',  '5'),  /* 0xBD = VULGAR FRACTION ONE HALF */
	BYTES(0xBE, 0xBE,  '&',  '6'),  /* 0xBE = VULGAR FRACTION THREE QUARTERS */
	BYTES( '{',  '{', 0x27,  '7'),  /* 0x27 = APOSTROPHE */
	BYTES( '[',  '[',  '(',  '8'),
	BYTES( ']',  ']',  ')',  '9'),
	BYTES( '}',  '}',  '=',  '0'),
	BYTES( 0x5C,  0x5C,'?',  '/'),  /* 0x5C = REVERSE SOLIDUS */
	BYTES( '|',  '|',  '_',  '-'),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES( '0',  '0',  '0',  '0'),

	/*---- 2nd QWERTY row - 0x10 to 0x1F */

	BYTES( '@',  '@',  'F',  'f'),
	BYTES( 'G',  'g',  'G',  'g'),
	BYTES(0xD0, 0xF0, 0xD0, 0xF0),  /* 0XD0 = LATIN CAPITAL LETTER G WITH BREVE, 0XF0 = LATIN SMALL LETTER G WITH BREVE */
	BYTES( 'I', 0xB6,  'I', 0xFD),  /* 0XB6 = PILCROW SIGN, 0XFD =  LATIN SMALL LETTER DOTLESS I */
	BYTES( 'O',  'o',  'O',  'o'),
	BYTES( 'D', 0xA5,  'D',  'd'),  /* 0XA5 = YEN SIGN */ 
	BYTES( 'R',  'r',  'R',  'r'),
	BYTES( 'N',  'n',  'N',  'n'),  
	BYTES( 'H', 0xD8,  'H',  'h'),  /* 0XD8 = LATIN CAPITAL LETTER O WITH STROKE */
	BYTES( 'P', 0xA3,  'P',  'p'),  /* 0XA3 = POUND SIGN */
	BYTES( 'Q', 0xA8,  'Q',  'q'),  /* 0XA8 = DIAERESIS */
	BYTES( '~',  '~',  'W',  'w'),  
	BYTES(   0,    0,    0,    0),
	BYTES( '1',  '1',  '1',  '1'),
	BYTES( '2',  '2',  '2',  '2'),
	BYTES( '3',  '3',  '3',  '3'),

	/*---- 3rd QWERTY row - 0x20 to 0x2F */

	BYTES(0xC6, 0xE6,  'U',  'u'),  /* 0XC6 = LATIN CAPITAL LETTER AE , 0XE6 = LATIN SMALL LETTER AE */
	BYTES(0xDD, 0xDF, 0xDD,  'i'),  /* 0xDD = LATIN CAPITAL LETTER I WITH DOT ABOVE, 0XDF = LATIN SMALL LETTER SHARP S */
	BYTES( 'E',  'e',  'E',  'e'),
	BYTES( 'A',  'a',  'A',  'a'),  
	BYTES(0XDC, 0xFC, 0xDC, 0xFC),  /* 0xDC = LATIN CAPITAL LETTER U WITH DIAERESIS, 0xFC = LATIN SMALL LETTER U WITH DIAERESIS */
	BYTES( 'T',  't',  'T',  't'),
	BYTES( 'K',  'k',  'K',  'k'),
	BYTES( 'M',  'm',  'M',  'm'),
	BYTES( 'L',  'l',  'L',  'l'),
	BYTES( 'Y', 0xB4,  'Y',  'y'),  /* 0XB4 = ACUTE ACCENT */
	BYTES(0xDE, 0xfe, 0xDE, 0xFE),  /* 0XDE = LATIN CAPITAL LETTER S WITH CEDILLA,  0XFE = LATIN SMALL LETTER S WITH CEDILLA */
	BYTES(0x60, 0x60,  'X',  'x'),  /* 0X60 = GRAVE ACCENT */
	BYTES(   0,    0,    0,    0),
	BYTES( '4',  '4',  '4',  '4'),
	BYTES( '5',  '5',  '5',  '5'),
	BYTES( '6',  '6',  '6',  '6'),

	/*---- 4th QWERTY row - 0x30 to 0x3F */

	BYTES( '>',  '|',  '>',  '<'),
	BYTES(0XAB, 0XAB,  'J',  'j'),  /* 0XAB = LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	BYTES(0xBB, 0xBB, 0xD6, 0xF6),  /* 0XBB = RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK, 0XD6 = LATIN CAPITAL LETTER O WITH DIAERESIS , 0XF6 = LATIN SMALL LETTER O WITH DIAERESIS */
	BYTES(0XA2, 0XA2,  'V',  'v'),  /* 0XA2 = CENT SIGN */
	BYTES( 'C', 0xA9,  'C',  'c'),  /* 0xA9 = COPYRIGHT SIGN */
	BYTES(0xC7, 0xE7, 0xC7, 0xE7),  /* 0xC7 = LATIN CAPITAL LETTER C WITH CEDILLA, 0xE7 = LATIN SMALL LETTER C WITH CEDILLA */
	BYTES( 'Z',  'z',  'Z',  'z'),
	BYTES( 'S', 0xB5,  'S',  's'),  /* 0xB5 = MICRO SIGN */
	BYTES(0XD7, 0XD7,  'B',  'b'),  /* 0XD7 = MULTIPLICATION SIGN */
	BYTES(0XF7, 0xF7,  ':',  '.'),  /* 0XF7 = DIVISION SIGN */
	BYTES( '-',  '-',  ';',  ','),
	BYTES(   0,    0,    0,    0),
	BYTES( ',',  ',',  ',',  ','),
	BYTES( '7',  '7',  '7',  '7'),
	BYTES( '8',  '8',  '8',  '8'),
	BYTES( '9',  '9',  '9',  '9'),
};

#include "standard.h"

STATIC CONST IPTR hikeymap[] =
{
	BYTES( ' ',  ' ',  ' ',  ' '),
	BYTES(0x08, 0x08, 0x08, 0x08),
	STRING(tab_descr),
	BYTES(0x0D, 0x0D, 0x0D, 0x0D),
	BYTES(   0,    0, 0x0A, 0x0D),
	BYTES(   0,    0, 0x9B, 0x1B),
	BYTES(0x7F, 0x7F, 0x7F, 0x7F),
	STRING(insert_descr),
	STRING(pageup_descr),
	STRING(pagedown_descr),
	BYTES( '-',  '-',  '-',  '-'),
	STRING(f11_descr),
	STRING(up_descr),
	STRING(down_descr),
	STRING(right_descr),
	STRING(left_descr),
	STRING(f1_descr),
	STRING(f2_descr),
	STRING(f3_descr),
	STRING(f4_descr),
	STRING(f5_descr),
	STRING(f6_descr),
	STRING(f7_descr),
	STRING(f8_descr),
	STRING(f9_descr),
	STRING(f10_descr),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES( '/',  '/',  '/',  '/'),
	BYTES( '*',  '*',  '*',  '*'),
	BYTES( '+',  '+',  '+',  '+'),
	STRING(help_descr),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	STRING(pausebreak_descr),
	STRING(f12_descr),
	STRING(home_descr),
	STRING(end_descr),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
	BYTES(   0,    0,    0,    0),
};

#undef SETBITS

#define SETBITS(b0, b1, b2, b3, b4, b5, b6, b7) \
	(b0<<0)|(b1<<1)|(b2<<2)|(b3<<3)|(b4<<4)|(b5<<5)|(b6<<6)|(b7<<7)
	
STATIC CONST UBYTE locapsable[] =
{
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),    /* 00 - 07 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),    /* 08 - 0F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),    /* 10 - 17 */
	SETBITS(1, 1, 1, 1, 0, 0, 0, 0),    /* 18 - 1F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),    /* 20 - 27 */
	SETBITS(1, 1, 1, 0, 0, 0, 0, 0),    /* 28 - 2F */
	
	SETBITS(0, 1, 1, 1, 1, 1, 1, 1),    /* 30 - 37 */
	SETBITS(1, 1, 0, 0, 0, 0, 0, 0)     /* 38 - 3F */
};

STATIC CONST UBYTE hicapsable[] =
{
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 40 - 47 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 48 - 4F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 58 - 5F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

STATIC CONST UBYTE lorepeatable[] =
{
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 00 - 07 */
	SETBITS(1, 1, 1, 1, 1, 1, 0, 1),	/* 08 - 0F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
	SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 18 - 1F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
	SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 28 - 2F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 30 - 37 */
	SETBITS(1, 1, 1, 0, 1, 1, 1, 1)	/* 38 - 3F */
};

STATIC CONST UBYTE hirepeatable[] =
{
	SETBITS(1, 1, 1, 0, 0, 0, 1, 0),	/* 40 - 47 */
	SETBITS(1, 1, 0, 0, 1, 1, 1, 1),	/* 48 - 4F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
	SETBITS(0, 0, 1, 1, 1, 1, 1, 0),	/* 58 - 5F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};


#define HAVE_UNICODE_CONVTABLE 1
#define HAVE_CHARSET_CONVTABLE 1

STATIC CONST ULONG unicodetable[] =
{
	// 0xD0 - 0xDF
	0x011E, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
	0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x0130, 0x015E, 0x00DF,

	// 0xE0 - 0xEF
	0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
	0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,

	// 0xF0 - 0xFF
	0x011F, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
	0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x0131, 0x015F, 0x00FF
};


STATIC CONST struct UCS4_ConvTable convtable =
{
	0xD0,
	0xFF,
	unicodetable
};


STATIC CONST UBYTE chartable1[2] =
{
	// 0x011E - 0x011F
	0xD0, 0xF0
};

STATIC CONST UBYTE chartable2[2] =
{
	// 0x0130 - 0x0131
	0xDD, 0xFD
};

STATIC CONST UBYTE chartable3[2] =
{
	// 0x015E - 0x015F
	0xDE, 0xFE
};


STATIC CONST struct UCS4_CharsetConvTable convtable2 =
{
	NULL,
	{
		{ 0x011E, 0x011F, chartable1 },
		{ 0x0130, 0x0131, chartable2 },
		{ 0x015E, 0x015F, chartable3 },
		{ 0x0000, 0x0000, NULL }
	}
};                         


#include "query.c"
